precision mediump float;

uniform sampler2D texture_albedo_normal_1;

varying vec4 v_colour;
varying vec2 v_uv;
varying vec2 v_screenpos;
varying vec3 v_lightdir;

void main()
{
    vec4 normal    = texture2D( texture_albedo_normal_1,v_screenpos);    
    normal = (normal*2.0)-1.0;
    
    // Calculate lighting intensity            
    float lightIntensity = max(0.4,dot(normalize(normal.xyz),-normalize(v_lightdir)));          
    vec3 vLI = vec3(lightIntensity,lightIntensity,lightIntensity);
    
    // Calculate gradient ( range between 1.0 to 0.6 )
    vec2 invUV = v_uv;
    invUV = invUV * 0.4;
    invUV = min(invUV + 0.6,1.0);
    
    gl_FragColor  = vec4(vLI.xxx * invUV.yyy * v_colour.rgb,invUV.y*v_colour.a);        
}
